/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.jdbc;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.acls.Acl;
import org.springframework.security.acls.AclService;
import org.springframework.security.acls.NotFoundException;
import org.springframework.security.acls.jdbc.LookupStrategy;
import org.springframework.security.acls.objectidentity.ObjectIdentity;
import org.springframework.security.acls.objectidentity.ObjectIdentityImpl;
import org.springframework.security.acls.sid.Sid;
import org.springframework.util.Assert;

public class JdbcAclService
implements AclService {
    protected static final Log log = LogFactory.getLog((Class)(class$org$springframework$security$acls$jdbc$JdbcAclService == null ? (class$org$springframework$security$acls$jdbc$JdbcAclService = JdbcAclService.class$("org.springframework.security.acls.jdbc.JdbcAclService")) : class$org$springframework$security$acls$jdbc$JdbcAclService));
    private static final String selectAclObjectWithParent = "SELECT obj.object_id_identity obj_id, class.class class FROM acl_object_identity obj, acl_object_identity parent, acl_class class WHERE obj.parent_object = parent.id AND obj.object_id_class = class.id AND parent.object_id_identity = ? AND parent.object_id_class = (SELECT id FROM acl_class WHERE acl_class.class = ?)";
    protected JdbcTemplate jdbcTemplate;
    private LookupStrategy lookupStrategy;
    static /* synthetic */ Class class$org$springframework$security$acls$jdbc$JdbcAclService;

    public JdbcAclService(DataSource dataSource, LookupStrategy lookupStrategy) {
        Assert.notNull((Object)dataSource, (String)"DataSource required");
        Assert.notNull((Object)lookupStrategy, (String)"LookupStrategy required");
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.lookupStrategy = lookupStrategy;
    }

    public ObjectIdentity[] findChildren(ObjectIdentity parentIdentity) {
        Object[] args = new Object[]{parentIdentity.getIdentifier(), parentIdentity.getJavaType().getName()};
        List objects = this.jdbcTemplate.query(selectAclObjectWithParent, args, new RowMapper(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                String javaType = rs.getString("class");
                Long identifier = new Long(rs.getLong("obj_id"));
                return new ObjectIdentityImpl(javaType, (Serializable)identifier);
            }
        });
        if (objects.size() == 0) {
            return null;
        }
        return objects.toArray(new ObjectIdentityImpl[objects.size()]);
    }

    public Acl readAclById(ObjectIdentity object, Sid[] sids) throws NotFoundException {
        Map map = this.readAclsById(new ObjectIdentity[]{object}, sids);
        Assert.isTrue((boolean)map.containsKey(object), (String)("There should have been an Acl entry for ObjectIdentity " + object));
        return (Acl)map.get(object);
    }

    public Acl readAclById(ObjectIdentity object) throws NotFoundException {
        return this.readAclById(object, null);
    }

    public Map readAclsById(ObjectIdentity[] objects) throws NotFoundException {
        return this.readAclsById(objects, null);
    }

    public Map readAclsById(ObjectIdentity[] objects, Sid[] sids) throws NotFoundException {
        Map result = this.lookupStrategy.readAclsById(objects, sids);
        for (int i = 0; i < objects.length; ++i) {
            if (result.containsKey(objects[i])) continue;
            throw new NotFoundException("Unable to find ACL information for object identity '" + objects[i].toString() + "'");
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

