/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterResponse;
import twitter4j.User;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectMessage
extends TwitterResponse
implements Serializable {
    private User sender;
    private User recipient;

    DirectMessage(Element elem, Twitter twitter) throws TwitterException {
        super(elem, twitter);
        this.ensureRootNodeNameIs("direct_message");
        this.sender = new User((Element)elem.getElementsByTagName("sender").item(0), twitter);
        this.recipient = new User((Element)elem.getElementsByTagName("recipient").item(0), twitter);
    }

    public int getId() {
        return this.getChildInt("id");
    }

    public String getText() {
        return this.getChildText("text");
    }

    public int getSenderId() {
        return this.getChildInt("sender_id");
    }

    public int getRecipientId() {
        return this.getChildInt("recipient_id");
    }

    public String getCreatedAt() {
        return this.getChildText("created_at");
    }

    public String getSenderScreenName() {
        return this.getChildText("sender_screen_name");
    }

    public String getRecipientScreenName() {
        return this.getChildText("recipient_screen_name");
    }

    public User getSender() {
        return this.sender;
    }

    public User getRecipient() {
        return this.recipient;
    }

    static List<DirectMessage> constructDirectMessages(Document doc, Twitter twitter) throws TwitterException {
        if (null == doc) {
            return new ArrayList<DirectMessage>(0);
        }
        try {
            DirectMessage.ensureRootNodeNameIs("direct-messages", doc.getDocumentElement());
            NodeList list = doc.getDocumentElement().getElementsByTagName("direct_message");
            int size = list.getLength();
            ArrayList<DirectMessage> messages = new ArrayList<DirectMessage>(size);
            for (int i = 0; i < size; ++i) {
                Element status = (Element)list.item(i);
                messages.add(new DirectMessage(status, twitter));
            }
            return messages;
        }
        catch (TwitterException te) {
            DirectMessage.ensureRootNodeNameIs("nil-classes", doc.getDocumentElement());
            return new ArrayList<DirectMessage>(0);
        }
    }

    @Override
    public int hashCode() {
        return this.elem.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof DirectMessage) {
            ((DirectMessage)obj).elem.equals(this.elem);
        }
        return false;
    }
}

