/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.codebehind;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.UnknownHandler;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.InterceptorLocator;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.config.entities.ResultTypeConfig;
import com.opensymphony.xwork2.config.providers.InterceptorBuilder;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.struts2.util.ClassLoaderUtils;

public class CodebehindUnknownHandler
implements UnknownHandler {
    protected String defaultPackageName;
    protected ServletContext servletContext;
    protected Map<String, ResultTypeConfig> resultsByExtension;
    protected String templatePathPrefix;
    protected Configuration configuration;
    protected ObjectFactory objectFactory;
    protected static final Logger LOG = LoggerFactory.getLogger(CodebehindUnknownHandler.class);

    @Inject
    public CodebehindUnknownHandler(@Inject(value="struts.codebehind.defaultPackage") String defaultPackage, @Inject Configuration configuration) {
        this.configuration = configuration;
        this.defaultPackageName = defaultPackage;
        this.resultsByExtension = new LinkedHashMap<String, ResultTypeConfig>();
        PackageConfig parentPackage = configuration.getPackageConfig(this.defaultPackageName);
        if (parentPackage == null) {
            throw new ConfigurationException("Unknown parent package: " + parentPackage);
        }
        Map results = parentPackage.getAllResultTypeConfigs();
        this.resultsByExtension.put("jsp", (ResultTypeConfig)results.get("dispatcher"));
        this.resultsByExtension.put("vm", (ResultTypeConfig)results.get("velocity"));
        this.resultsByExtension.put("ftl", (ResultTypeConfig)results.get("freemarker"));
    }

    @Inject(value="struts.codebehind.pathPrefix")
    public void setPathPrefix(String prefix) {
        this.templatePathPrefix = prefix;
    }

    @Inject
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Inject
    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public ActionConfig handleUnknownAction(String namespace, String actionName) throws XWorkException {
        String pathPrefix = this.determinePath(this.templatePathPrefix, namespace);
        ActionConfig actionConfig = null;
        for (String ext : this.resultsByExtension.keySet()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trying to locate unknown action template with extension ." + ext + " in directory " + pathPrefix, new String[0]);
            }
            String path = this.string(pathPrefix, actionName, ".", ext);
            try {
                if (this.locateTemplate(path) == null) continue;
                actionConfig = this.buildActionConfig(path, namespace, actionName, this.resultsByExtension.get(ext));
                break;
            }
            catch (MalformedURLException e) {
                LOG.warn("Unable to parse template path: " + path + ", skipping...", new String[0]);
            }
        }
        return actionConfig;
    }

    protected ActionConfig buildActionConfig(String path, String namespace, String actionName, ResultTypeConfig resultTypeConfig) {
        PackageConfig pkg = this.configuration.getPackageConfig(this.defaultPackageName);
        return new ActionConfig.Builder(this.defaultPackageName, "execute", ActionSupport.class.getName()).addInterceptors(InterceptorBuilder.constructInterceptorReference((InterceptorLocator)pkg, (String)pkg.getFullDefaultInterceptorRef(), (Map)Collections.EMPTY_MAP, null, (ObjectFactory)this.objectFactory)).addResultConfig(new ResultConfig.Builder("success", resultTypeConfig.getClassName()).addParams(resultTypeConfig.getParams()).addParam(resultTypeConfig.getDefaultResultParam(), path).build()).build();
    }

    public Result handleUnknownResult(ActionContext actionContext, String actionName, ActionConfig actionConfig, String resultCode) throws XWorkException {
        Result result = null;
        PackageConfig pkg = this.configuration.getPackageConfig(actionConfig.getPackageName());
        String ns = pkg.getNamespace();
        String pathPrefix = this.determinePath(this.templatePathPrefix, ns);
        for (String ext : this.resultsByExtension.keySet()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trying to locate result with extension ." + ext + " in directory " + pathPrefix, new String[0]);
            }
            String path = this.string(pathPrefix, actionName, "-", resultCode, ".", ext);
            try {
                if (this.locateTemplate(path) != null) {
                    result = this.buildResult(path, resultCode, this.resultsByExtension.get(ext), actionContext);
                    break;
                }
            }
            catch (MalformedURLException e) {
                LOG.warn("Unable to parse template path: " + path + ", skipping...", new String[0]);
            }
            path = this.string(pathPrefix, actionName, ".", ext);
            try {
                if (this.locateTemplate(path) == null) continue;
                result = this.buildResult(path, resultCode, this.resultsByExtension.get(ext), actionContext);
                break;
            }
            catch (MalformedURLException e) {
                LOG.warn("Unable to parse template path: " + path + ", skipping...", new String[0]);
            }
        }
        return result;
    }

    protected Result buildResult(String path, String resultCode, ResultTypeConfig config, ActionContext invocationContext) {
        ResultConfig resultConfig = new ResultConfig.Builder(resultCode, config.getClassName()).addParams(config.getParams()).addParam(config.getDefaultResultParam(), path).build();
        try {
            return this.objectFactory.buildResult(resultConfig, invocationContext.getContextMap());
        }
        catch (Exception e) {
            throw new XWorkException("Unable to build codebehind result", (Throwable)e, (Object)resultConfig);
        }
    }

    protected String string(String ... parts) {
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            sb.append(part);
        }
        return sb.toString();
    }

    protected String determinePath(String prefix, String ns) {
        if (ns == null || "/".equals(ns)) {
            ns = "";
        }
        if (ns.length() > 0) {
            if (ns.charAt(0) == '/') {
                ns = ns.substring(1);
            }
            if (ns.charAt(ns.length() - 1) != '/') {
                ns = ns + "/";
            }
        }
        return prefix + ns;
    }

    URL locateTemplate(String path) throws MalformedURLException {
        URL template = this.servletContext.getResource(path);
        if (template != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loaded template '" + path + "' from servlet context.", new String[0]);
            }
        } else {
            template = ClassLoaderUtils.getResource((String)path, this.getClass());
            if (template != null && LOG.isDebugEnabled()) {
                LOG.debug("Loaded template '" + path + "' from class path.", new String[0]);
            }
        }
        return template;
    }

    public Object handleUnknownActionMethod(Object action, String methodName) throws NoSuchMethodException {
        throw new NoSuchMethodException();
    }
}

