/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.operation;

import java.util.ArrayList;
import java.util.BitSet;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DataSetUtils;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoPrimaryKeyException;
import org.dbunit.operation.AbstractBatchOperation;
import org.dbunit.operation.OperationData;

public class UpdateOperation
extends AbstractBatchOperation {
    UpdateOperation() {
    }

    public OperationData getOperationData(ITableMetaData metaData, BitSet ignoreMapping, IDatabaseConnection connection) throws DataSetException {
        Column[] columns = metaData.getColumns();
        Column[] primaryKeys = metaData.getPrimaryKeys();
        if (primaryKeys.length == 0) {
            throw new NoPrimaryKeyException(metaData.getTableName());
        }
        StringBuffer sqlBuffer = new StringBuffer(128);
        sqlBuffer.append("update ");
        sqlBuffer.append(this.getQualifiedName(connection.getSchema(), metaData.getTableName(), connection));
        boolean firstSet = true;
        ArrayList<Column> columnList = new ArrayList<Column>(columns.length);
        sqlBuffer.append(" set ");
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (DataSetUtils.getColumn(column.getColumnName(), primaryKeys) == null) {
                if (!firstSet) {
                    sqlBuffer.append(", ");
                }
                firstSet = false;
                String columnName = this.getQualifiedName(null, column.getColumnName(), connection);
                sqlBuffer.append(columnName);
                sqlBuffer.append(" = ?");
                columnList.add(column);
            }
            ++i;
        }
        sqlBuffer.append(" where ");
        int i2 = 0;
        while (i2 < primaryKeys.length) {
            Column column = primaryKeys[i2];
            if (i2 > 0) {
                sqlBuffer.append(" and ");
            }
            String columnName = this.getQualifiedName(null, column.getColumnName(), connection);
            sqlBuffer.append(columnName);
            sqlBuffer.append(" = ?");
            columnList.add(column);
            ++i2;
        }
        return new OperationData(sqlBuffer.toString(), columnList.toArray(new Column[0]));
    }
}

