/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database.search;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.search.ForeignKeyRelationshipEdge;
import org.dbunit.util.search.AbstractNodesFilterSearchCallback;
import org.dbunit.util.search.IEdge;
import org.dbunit.util.search.SearchException;

public abstract class AbstractMetaDataBasedSearchCallback
extends AbstractNodesFilterSearchCallback {
    private final IDatabaseConnection connection;
    protected static final int IMPORT = 0;
    protected static final int EXPORT = 1;
    protected static final int[] TABLENAME_INDEXES = new int[]{3, 7};
    protected static final int[] PK_INDEXES = new int[]{4, 4};
    protected static final int[] FK_INDEXES = new int[]{8, 8};

    public AbstractMetaDataBasedSearchCallback(IDatabaseConnection connection) {
        this.connection = connection;
    }

    public IDatabaseConnection getConnection() {
        return this.connection;
    }

    protected SortedSet getNodesFromImportedKeys(Object node) throws SearchException {
        return this.getNodes(0, node);
    }

    protected SortedSet getNodesFromExportedKeys(Object node) throws SearchException {
        return this.getNodes(1, node);
    }

    protected SortedSet getNodesFromImportAndExportKeys(Object node) throws SearchException {
        SortedSet importedNodes = this.getNodesFromImportedKeys(node);
        SortedSet exportedNodes = this.getNodesFromExportedKeys(node);
        importedNodes.addAll(exportedNodes);
        return importedNodes;
    }

    private SortedSet getNodes(int type, Object node) throws SearchException {
        try {
            Connection conn = this.connection.getConnection();
            String schema = this.connection.getSchema();
            DatabaseMetaData metaData = conn.getMetaData();
            TreeSet edges = new TreeSet();
            this.getNodes(type, node, conn, schema, metaData, edges);
            return edges;
        }
        catch (SQLException e) {
            throw new SearchException(e);
        }
    }

    private void getNodes(int type, Object node, Connection conn, String schema, DatabaseMetaData metaData, SortedSet edges) throws SearchException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Getting edges for node " + node));
        }
        try {
            if (!(node instanceof String)) {
                throw new IllegalArgumentException("node should be a String, not a " + node.getClass().getName());
            }
            String tableName = (String)node;
            ResultSet rs = null;
            switch (type) {
                case 0: {
                    rs = metaData.getImportedKeys(null, schema, tableName);
                    break;
                }
                case 1: {
                    rs = metaData.getExportedKeys(null, schema, tableName);
                }
            }
            while (rs.next()) {
                int index = TABLENAME_INDEXES[type];
                String dependentTableName = rs.getString(index);
                String pkColumn = rs.getString(PK_INDEXES[type]);
                String fkColumn = rs.getString(FK_INDEXES[type]);
                IEdge edge = this.newEdge(rs, type, tableName, dependentTableName, fkColumn, pkColumn);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Adding edge " + edge));
                }
                edges.add(edge);
            }
        }
        catch (SQLException e) {
            throw new SearchException(e);
        }
    }

    protected static ForeignKeyRelationshipEdge createFKEdge(ResultSet rs, int type, String from, String to, String fkColumn, String pkColumn) throws SearchException {
        return type == 0 ? new ForeignKeyRelationshipEdge(from, to, fkColumn, pkColumn) : new ForeignKeyRelationshipEdge(to, from, fkColumn, pkColumn);
    }

    protected IEdge newEdge(ResultSet rs, int type, String from, String to, String fkColumn, String pkColumn) throws SearchException {
        return AbstractMetaDataBasedSearchCallback.createFKEdge(rs, type, from, to, fkColumn, pkColumn);
    }
}

