/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor.validation;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ValidationAware;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.text.StringCharacterIterator;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONValidationInterceptor
extends MethodFilterInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(JSONValidationInterceptor.class);
    private static final String VALIDATE_ONLY_PARAM = "struts.validateOnly";
    private static final String VALIDATE_JSON_PARAM = "struts.enableJSONValidation";
    static char[] hex = "0123456789ABCDEF".toCharArray();
    private int validationFailedStatus = -1;

    public void setValidationFailedStatus(int validationFailedStatus) {
        this.validationFailedStatus = validationFailedStatus;
    }

    protected String doIntercept(ActionInvocation invocation) throws Exception {
        HttpServletResponse response = ServletActionContext.getResponse();
        HttpServletRequest request = ServletActionContext.getRequest();
        Object action = invocation.getAction();
        String jsonEnabled = request.getParameter(VALIDATE_JSON_PARAM);
        if (jsonEnabled != null && "true".equals(jsonEnabled)) {
            ValidationAware validationAware;
            if (action instanceof ValidationAware && (validationAware = (ValidationAware)action).hasErrors()) {
                if (this.validationFailedStatus >= 0) {
                    response.setStatus(this.validationFailedStatus);
                }
                response.getWriter().print(this.buildResponse(validationAware));
                return "none";
            }
            String validateOnly = request.getParameter(VALIDATE_ONLY_PARAM);
            if (validateOnly != null && "true".equals(validateOnly)) {
                response.getWriter().print("/* {} */");
                return "none";
            }
            return invocation.invoke();
        }
        return invocation.invoke();
    }

    protected String buildResponse(ValidationAware validationAware) {
        StringBuilder sb = new StringBuilder();
        sb.append("/* { ");
        if (validationAware.hasErrors()) {
            if (validationAware.hasActionErrors()) {
                sb.append("\"errors\":");
                sb.append(this.buildArray(validationAware.getActionErrors()));
            }
            if (validationAware.hasFieldErrors()) {
                if (validationAware.hasActionErrors()) {
                    sb.append(",");
                }
                sb.append("\"fieldErrors\": {");
                Map fieldErrors = validationAware.getFieldErrors();
                for (Map.Entry fieldError : fieldErrors.entrySet()) {
                    sb.append("\"");
                    sb.append((String)fieldError.getKey());
                    sb.append("\":");
                    sb.append(this.buildArray((Collection)fieldError.getValue()));
                    sb.append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append("}");
            }
        }
        sb.append("} */");
        return sb.toString();
    }

    private String buildArray(Collection<String> values) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (String value : values) {
            sb.append("\"");
            sb.append(this.escapeJSON(value));
            sb.append("\",");
        }
        if (values.size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }

    private String escapeJSON(Object obj) {
        StringBuilder sb = new StringBuilder();
        StringCharacterIterator it = new StringCharacterIterator(obj.toString());
        char c = it.first();
        while (c != '\uffff') {
            if (c == '\"') {
                sb.append("\\\"");
            } else if (c == '\\') {
                sb.append("\\\\");
            } else if (c == '/') {
                sb.append("\\/");
            } else if (c == '\b') {
                sb.append("\\b");
            } else if (c == '\f') {
                sb.append("\\f");
            } else if (c == '\n') {
                sb.append("\\n");
            } else if (c == '\r') {
                sb.append("\\r");
            } else if (c == '\t') {
                sb.append("\\t");
            } else if (Character.isISOControl(c)) {
                sb.append(this.unicode(c));
            } else {
                sb.append(c);
            }
            c = it.next();
        }
        return sb.toString();
    }

    private String unicode(char c) {
        StringBuilder sb = new StringBuilder();
        sb.append("\\u");
        int n = c;
        for (int i = 0; i < 4; ++i) {
            int digit = (n & 0xF000) >> 12;
            sb.append(hex[digit]);
            n <<= 4;
        }
        return sb.toString();
    }
}

