/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.StrutsResultSupport;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;

public class ServletRedirectResult
extends StrutsResultSupport {
    private static final long serialVersionUID = 6316947346435301270L;
    private static final Logger LOG = LoggerFactory.getLogger(ServletRedirectResult.class);
    protected boolean prependServletContext = true;
    protected ActionMapper actionMapper;
    protected int statusCode = 302;

    public ServletRedirectResult() {
    }

    public ServletRedirectResult(String location) {
        super(location);
    }

    @Inject
    public void setActionMapper(ActionMapper mapper) {
        this.actionMapper = mapper;
    }

    public void setStatusCode(int code) {
        this.statusCode = code;
    }

    public void setPrependServletContext(boolean prependServletContext) {
        this.prependServletContext = prependServletContext;
    }

    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        ActionContext ctx = invocation.getInvocationContext();
        HttpServletRequest request = (HttpServletRequest)ctx.get((Object)"com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        HttpServletResponse response = (HttpServletResponse)ctx.get((Object)"com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        if (ServletRedirectResult.isPathUrl(finalLocation)) {
            if (!finalLocation.startsWith("/")) {
                ActionMapping mapping = this.actionMapper.getMapping(request, Dispatcher.getInstance().getConfigurationManager());
                String namespace = null;
                if (mapping != null) {
                    namespace = mapping.getNamespace();
                }
                finalLocation = namespace != null && namespace.length() > 0 && !"/".equals(namespace) ? namespace + "/" + finalLocation : "/" + finalLocation;
            }
            if (this.prependServletContext && request.getContextPath() != null && request.getContextPath().length() > 0) {
                finalLocation = request.getContextPath() + finalLocation;
            }
            finalLocation = response.encodeRedirectURL(finalLocation);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Redirecting to finalLocation " + finalLocation, new String[0]);
        }
        this.sendRedirect(response, finalLocation);
    }

    protected void sendRedirect(HttpServletResponse response, String finalLocation) throws IOException {
        if (302 == this.statusCode) {
            response.sendRedirect(finalLocation);
        } else {
            response.setStatus(this.statusCode);
            response.setHeader("Location", finalLocation);
            response.getWriter().write(finalLocation);
            response.getWriter().close();
        }
    }

    private static boolean isPathUrl(String url) {
        return url.indexOf(58) == -1;
    }
}

