/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.profiling.UtilTimerStack;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.RequestUtils;
import org.apache.struts2.StrutsStatics;
import org.apache.struts2.dispatcher.ActionContextCleanUp;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.util.ClassLoaderUtils;

public class FilterDispatcher
implements StrutsStatics,
Filter {
    private Logger log;
    private String[] pathPrefixes;
    private final Calendar lastModifiedCal = Calendar.getInstance();
    private boolean serveStatic;
    private boolean serveStaticBrowserCache;
    private String encoding;
    private ActionMapper actionMapper;
    private FilterConfig filterConfig;
    protected Dispatcher dispatcher;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.initLogging();
        this.dispatcher = this.createDispatcher(filterConfig);
        this.dispatcher.init();
        this.dispatcher.getContainer().inject((Object)this);
        String param = filterConfig.getInitParameter("packages");
        String packages = "org.apache.struts2.static template org.apache.struts2.interceptor.debugging";
        if (param != null) {
            packages = param + " " + packages;
        }
        this.pathPrefixes = this.parse(packages);
    }

    private void initLogging() {
        String factoryName = this.filterConfig.getInitParameter("loggerFactory");
        if (factoryName != null) {
            try {
                Class cls = ClassLoaderUtils.loadClass(factoryName, this.getClass());
                LoggerFactory fac = (LoggerFactory)cls.newInstance();
                LoggerFactory.setLoggerFactory((LoggerFactory)fac);
            }
            catch (InstantiationException e) {
                System.err.println("Unable to instantiate logger factory: " + factoryName + ", using default");
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                System.err.println("Unable to access logger factory: " + factoryName + ", using default");
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                System.err.println("Unable to locate logger factory class: " + factoryName + ", using default");
                e.printStackTrace();
            }
        }
        this.log = LoggerFactory.getLogger(FilterDispatcher.class);
    }

    public void destroy() {
        if (this.dispatcher == null) {
            this.log.warn("something is seriously wrong, Dispatcher is not initialized (null) ", new String[0]);
        } else {
            this.dispatcher.cleanup();
        }
    }

    protected Dispatcher createDispatcher(FilterConfig filterConfig) {
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration e = filterConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = filterConfig.getInitParameter(name);
            params.put(name, value);
        }
        return new Dispatcher(filterConfig.getServletContext(), params);
    }

    @Inject(value="struts.serve.static")
    public void setServeStaticContent(String val) {
        this.serveStatic = "true".equals(val);
    }

    @Inject(value="struts.serve.static.browserCache")
    public void setServeStaticBrowserCache(String val) {
        this.serveStaticBrowserCache = "true".equals(val);
    }

    @Inject(value="struts.i18n.encoding")
    public void setEncoding(String val) {
        this.encoding = val;
    }

    @Inject
    public void setActionMapper(ActionMapper mapper) {
        this.actionMapper = mapper;
    }

    protected ServletContext getServletContext() {
        return this.filterConfig.getServletContext();
    }

    protected FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    protected HttpServletRequest prepareDispatcherAndWrapRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        Dispatcher du = Dispatcher.getInstance();
        if (du == null) {
            Dispatcher.setInstance(this.dispatcher);
            this.dispatcher.prepare(request, response);
        } else {
            this.dispatcher = du;
        }
        try {
            request = this.dispatcher.wrapRequest(request, this.getServletContext());
        }
        catch (IOException e) {
            String message = "Could not wrap servlet request with MultipartRequestWrapper!";
            this.log.error(message, (Throwable)e, new String[0]);
            throw new ServletException(message, (Throwable)e);
        }
        return request;
    }

    protected String[] parse(String packages) {
        if (packages == null) {
            return null;
        }
        ArrayList<String> pathPrefixes = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(packages, ", \n\t");
        while (st.hasMoreTokens()) {
            String pathPrefix = st.nextToken().replace('.', '/');
            if (!pathPrefix.endsWith("/")) {
                pathPrefix = pathPrefix + "/";
            }
            pathPrefixes.add(pathPrefix);
        }
        return pathPrefixes.toArray(new String[pathPrefixes.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        ServletContext servletContext = this.getServletContext();
        String timerKey = "FilterDispatcher_doFilter: ";
        try {
            ActionMapping mapping;
            ValueStack stack = ((ValueStackFactory)this.dispatcher.getContainer().getInstance(ValueStackFactory.class)).createValueStack();
            ActionContext ctx = new ActionContext(stack.getContext());
            ActionContext.setContext((ActionContext)ctx);
            UtilTimerStack.push((String)timerKey);
            request = this.prepareDispatcherAndWrapRequest(request, response);
            try {
                mapping = this.actionMapper.getMapping(request, this.dispatcher.getConfigurationManager());
            }
            catch (Exception ex) {
                this.log.error("error getting ActionMapping", (Throwable)ex, new String[0]);
                this.dispatcher.sendError(request, response, servletContext, 500, ex);
                try {
                    ActionContextCleanUp.cleanUp(req);
                }
                finally {
                    UtilTimerStack.pop((String)timerKey);
                }
                return;
            }
            if (mapping == null) {
                String resourcePath = RequestUtils.getServletPath(request);
                if ("".equals(resourcePath) && null != request.getPathInfo()) {
                    resourcePath = request.getPathInfo();
                }
                if (this.serveStatic && resourcePath.startsWith("/struts")) {
                    String name = resourcePath.substring("/struts".length());
                    this.findStaticResource(name, request, response);
                } else {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
                return;
            }
            this.dispatcher.serviceAction(request, response, servletContext, mapping);
        }
        finally {
            try {
                ActionContextCleanUp.cleanUp(req);
            }
            finally {
                UtilTimerStack.pop((String)timerKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findStaticResource(String name, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!name.endsWith(".class")) {
            for (String pathPrefix : this.pathPrefixes) {
                InputStream is = this.findInputStream(name, pathPrefix);
                if (is == null) continue;
                Calendar cal = Calendar.getInstance();
                long ifModifiedSince = 0L;
                try {
                    ifModifiedSince = request.getDateHeader("If-Modified-Since");
                }
                catch (Exception e) {
                    this.log.warn("Invalid If-Modified-Since header value: '" + request.getHeader("If-Modified-Since") + "', ignoring", new String[0]);
                }
                long lastModifiedMillis = this.lastModifiedCal.getTimeInMillis();
                long now = cal.getTimeInMillis();
                cal.add(5, 1);
                long expires = cal.getTimeInMillis();
                if (ifModifiedSince > 0L && ifModifiedSince <= lastModifiedMillis) {
                    response.setDateHeader("Expires", expires);
                    response.setStatus(304);
                    is.close();
                    return;
                }
                String contentType = this.getContentType(name);
                if (contentType != null) {
                    response.setContentType(contentType);
                }
                if (this.serveStaticBrowserCache) {
                    response.setDateHeader("Date", now);
                    response.setDateHeader("Expires", expires);
                    response.setDateHeader("Retry-After", expires);
                    response.setHeader("Cache-Control", "public");
                    response.setDateHeader("Last-Modified", lastModifiedMillis);
                } else {
                    response.setHeader("Cache-Control", "no-cache");
                    response.setHeader("Pragma", "no-cache");
                    response.setHeader("Expires", "-1");
                }
                try {
                    this.copy(is, (OutputStream)response.getOutputStream());
                }
                finally {
                    is.close();
                }
                return;
            }
        }
        response.sendError(404);
    }

    protected String getContentType(String name) {
        if (name.endsWith(".js")) {
            return "text/javascript";
        }
        if (name.endsWith(".css")) {
            return "text/css";
        }
        if (name.endsWith(".html")) {
            return "text/html";
        }
        if (name.endsWith(".txt")) {
            return "text/plain";
        }
        if (name.endsWith(".gif")) {
            return "image/gif";
        }
        if (name.endsWith(".jpg") || name.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (name.endsWith(".png")) {
            return "image/png";
        }
        return null;
    }

    protected void copy(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        output.flush();
    }

    protected InputStream findInputStream(String name, String packagePrefix) throws IOException {
        String resourcePath = packagePrefix.endsWith("/") && name.startsWith("/") ? packagePrefix + name.substring(1) : packagePrefix + name;
        resourcePath = URLDecoder.decode(resourcePath, this.encoding);
        return ClassLoaderUtil.getResourceAsStream((String)resourcePath, this.getClass());
    }
}

