/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.components.ContextBean;
import org.apache.struts2.components.UrlRenderer;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.util.UrlHelper;

@StrutsTag(name="url", tldTagClass="org.apache.struts2.views.jsp.URLTag", description="This tag is used to create a URL")
public class URL
extends ContextBean {
    private static final Logger LOG = LoggerFactory.getLogger(URL.class);
    public static final String NONE = "none";
    public static final String GET = "get";
    public static final String ALL = "all";
    protected HttpServletRequest req;
    protected HttpServletResponse res;
    protected String includeParams;
    protected String scheme;
    protected String value;
    protected String action;
    protected String namespace;
    protected String method;
    protected boolean encode = true;
    protected boolean includeContext = true;
    protected boolean escapeAmp = true;
    protected String portletMode;
    protected String windowState;
    protected String portletUrlType;
    protected String anchor;
    protected boolean forceAddSchemeHostAndPort;
    protected String urlIncludeParams;
    protected ExtraParameterProvider extraParameterProvider;
    protected UrlRenderer urlRenderer;

    public URL(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        super(stack);
        this.req = req;
        this.res = res;
    }

    @Inject(value="struts.url.includeParams")
    public void setUrlIncludeParams(String urlIncludeParams) {
        this.urlIncludeParams = urlIncludeParams;
    }

    @Inject
    public void setUrlRenderer(UrlRenderer urlRenderer) {
        this.urlRenderer = urlRenderer;
    }

    @Inject(required=false)
    public void setExtraParameterProvider(ExtraParameterProvider provider) {
        this.extraParameterProvider = provider;
    }

    public boolean start(Writer writer) {
        boolean result = super.start(writer);
        if (this.value != null) {
            this.value = this.findString(this.value);
        }
        try {
            String includeParams;
            String string = includeParams = this.urlIncludeParams != null ? this.urlIncludeParams.toLowerCase() : GET;
            if (this.includeParams != null) {
                includeParams = this.findString(this.includeParams);
            }
            if (NONE.equalsIgnoreCase(includeParams)) {
                this.mergeRequestParameters(this.value, this.parameters, Collections.EMPTY_MAP);
            } else if (ALL.equalsIgnoreCase(includeParams)) {
                this.mergeRequestParameters(this.value, this.parameters, this.req.getParameterMap());
                this.includeGetParameters();
                this.includeExtraParameters();
            } else if (GET.equalsIgnoreCase(includeParams) || includeParams == null && this.value == null && this.action == null) {
                this.includeGetParameters();
                this.includeExtraParameters();
            } else if (includeParams != null) {
                LOG.warn("Unknown value for includeParams parameter to URL tag: " + includeParams, new String[0]);
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to put request parameters (" + this.req.getQueryString() + ") into parameter map.", (Throwable)e, new String[0]);
        }
        return result;
    }

    private void includeExtraParameters() {
        if (this.extraParameterProvider != null) {
            this.mergeRequestParameters(this.value, this.parameters, this.extraParameterProvider.getExtraParameters());
        }
    }

    private void includeGetParameters() {
        String query = this.extractQueryString();
        this.mergeRequestParameters(this.value, this.parameters, UrlHelper.parseQueryString(query));
    }

    private String extractQueryString() {
        int idx;
        String query = this.req.getQueryString();
        if (query == null) {
            query = (String)this.req.getAttribute("javax.servlet.forward.query_string");
        }
        if (query != null && (idx = query.lastIndexOf(35)) != -1) {
            query = query.substring(0, idx);
        }
        return query;
    }

    public boolean end(Writer writer, String body) {
        this.urlRenderer.renderUrl(writer, this);
        return super.end(writer, body);
    }

    @StrutsTagAttribute(description="The includeParams attribute may have the value 'none', 'get' or 'all'", defaultValue="get")
    public void setIncludeParams(String includeParams) {
        this.includeParams = includeParams;
    }

    @StrutsTagAttribute(description="Set scheme attribute")
    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    @StrutsTagAttribute(description="The target value to use, if not using action")
    public void setValue(String value) {
        this.value = value;
    }

    @StrutsTagAttribute(description="The action to generate the URL for, if not using value")
    public void setAction(String action) {
        this.action = action;
    }

    @StrutsTagAttribute(description="The namespace to use")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @StrutsTagAttribute(description="The method of action to use")
    public void setMethod(String method) {
        this.method = method;
    }

    @StrutsTagAttribute(description="Whether to encode parameters", type="Boolean", defaultValue="true")
    public void setEncode(boolean encode) {
        this.encode = encode;
    }

    @StrutsTagAttribute(description="Whether actual context should be included in URL", type="Boolean", defaultValue="true")
    public void setIncludeContext(boolean includeContext) {
        this.includeContext = includeContext;
    }

    @StrutsTagAttribute(description="The resulting portlet mode")
    public void setPortletMode(String portletMode) {
        this.portletMode = portletMode;
    }

    @StrutsTagAttribute(description="The resulting portlet window state")
    public void setWindowState(String windowState) {
        this.windowState = windowState;
    }

    @StrutsTagAttribute(description="Specifies if this should be a portlet render or action URL. Default is \"render\". To create an action URL, use \"action\".")
    public void setPortletUrlType(String portletUrlType) {
        this.portletUrlType = portletUrlType;
    }

    @StrutsTagAttribute(description="The anchor for this URL")
    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    @StrutsTagAttribute(description="Specifies whether to escape ampersand (&amp;) to (&amp;amp;) or not", type="Boolean", defaultValue="true")
    public void setEscapeAmp(boolean escapeAmp) {
        this.escapeAmp = escapeAmp;
    }

    @StrutsTagAttribute(description="Specifies whether to force the addition of scheme, host and port or not", type="Boolean", defaultValue="false")
    public void setForceAddSchemeHostAndPort(boolean forceAddSchemeHostAndPort) {
        this.forceAddSchemeHostAndPort = forceAddSchemeHostAndPort;
    }

    protected void mergeRequestParameters(String value, Map parameters, Map contextParameters) {
        Map mergedParams = new LinkedHashMap(contextParameters);
        if (value != null && value.trim().length() > 0 && value.indexOf("?") > 0) {
            mergedParams = new LinkedHashMap();
            String queryString = value.substring(value.indexOf("?") + 1);
            mergedParams = UrlHelper.parseQueryString(queryString);
            for (Map.Entry entry : contextParameters.entrySet()) {
                Object key = entry.getKey();
                if (mergedParams.containsKey(key)) continue;
                mergedParams.put(key, entry.getValue());
            }
        }
        for (Map.Entry entry : mergedParams.entrySet()) {
            Object key = entry.getKey();
            if (parameters.containsKey(key)) continue;
            parameters.put(key, entry.getValue());
        }
    }

    public static interface ExtraParameterProvider {
        public Map getExtraParameters();
    }
}

